/* 
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2001
 *  
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

//http://www.cpcwiki.eu/index.php/Programming_methods_used_in_games



#include "arnold.h"
#include "../cpc/cpc.h"
#include "../cpc/audio.h"
#include "../cpc/host.h"
#include "../special/win/Specific.h"
#include "../cpc/fdd.h"
#include "../cpc/autorunfile.h"
#include "../cpc/autotype.h"
#include "../special/win//cpcemu.h"
#include "../cpc/render.h"
#include "../cpc/fdc.h"
#include "../cpc/crtc.h"
#include "../cpc/joystick.h"

//http://www.cpcwiki.eu/index.php/Programming_methods_used_in_games

#include "z80/z80.h"

#include "../special/win/ifacegen.h"

#define FRAME_SKIP_MIN	0
#define FRAME_SKIP_MAX	10

void OneFrameAction (void);
void CPC_ExecuteCycles(int NopCount);

//extern BOOL VSYNC_Display;
extern long TestUpd2;
extern int Testupd3;

#ifdef SHOW_TIME

/* the following are for timing the emulation */
#define FRAME_TIME_IN_MS	(1000/50)
	
#define NUM_FRAMES_TO_TIME	10
static unsigned long FrameTimesInMs[NUM_FRAMES_TO_TIME];
static unsigned long FrameIndexForFrameTimes = 0;
static unsigned long Arnold_PreviousTimeInMs = 0;
static unsigned int Arnold_PercentRelativeSpeed = 0;
#endif

/* current frame index, compared against frame skip value */
static int CurrentFrameIndex = 0;
/* frame skip value */
static int FrameSkip = FRAME_SKIP_MIN;
/* number of nops executed in this frame so far */
static int NopCountToDate = NOPS_PER_MONITOR_SCREEN;
/* TRUE if audio is enabled, FALSE otherwise */
static bool AudioActiveFlag = FALSE;
 /* The accumulated Nop-count */
static int NopCountAcc = 0;

int CPU_ExecuteCycles(void);
int Cycles = 0;

BOOL MonitorNeedupdate(void);
long GetLenghtBuff(void);


#if 0
void	CPC_DoFrameFunc(void)
{

	/* Frame Skip Control code */

	/* update frame skip */
	CurrentFrameIndex++;

	if (CurrentFrameIndex==FrameSkip+1)
	{
		CurrentFrameIndex = 0;
		
		/* is rendering possible? */
		if (Render_IsRendererActive())
		{
			/* dump whole display to screen */
			Render_DumpDisplay();
		}
	}

	/* call speed throttle function - use this to 
	throttle speed at 100% */
	Host_Throttle();


    /* disc drive light indicator*/
    if (FDD_GetLEDState(0)!=0)
    {
       Host_DoDriveLEDIndicator(0, TRUE);
    }
    else
    {
       Host_DoDriveLEDIndicator(0, FALSE);
    }

/*	Host_ProcessSystemEvents(); */


	/* dont render */
	DontRender = TRUE;
	CRTC_SetRenderState(DontRender);

	/* should we render graphics? */
	if (CurrentFrameIndex == FrameSkip)
	{
		/* is rendering possible? */
		if (Render_IsRendererActive())
		{
			/* allow it to render */
			DontRender = FALSE;
			CRTC_SetRenderState(DontRender);
		}
	}

#ifdef SHOW_TIME
	/* works out the speed of the emulation based on the previous 10 
	frames. This method stores a frame time in ms for each frame in
	a table, when 10 frame times have been recorded, it works out
	the average of those times and updates the percentage speed. */
	{
		unsigned long CurrentTimeInMs;
		unsigned long MsPassed;
		int first = Arnold_PreviousTimeInMs;

		/* get time for this frame in ms */
		CurrentTimeInMs = Host_GetCurrentTimeInMilliseconds();

		/* work out ms passed based on previous ms value */
		MsPassed = CurrentTimeInMs - Arnold_PreviousTimeInMs;
		
		/* store this time */
		Arnold_PreviousTimeInMs = CurrentTimeInMs;
		
		if (!first)
		{
			/* store this frame time */
			FrameTimesInMs[FrameIndexForFrameTimes] = MsPassed;
			FrameIndexForFrameTimes++;

			if (FrameIndexForFrameTimes == NUM_FRAMES_TO_TIME)
			{
				int i;
				unsigned long AverageTime = 0;

				/* recalc relative speed */
				FrameIndexForFrameTimes = 0;

				for (i=0; i<NUM_FRAMES_TO_TIME; i++)
				{
					/* add on time for this frame */
					AverageTime+=FrameTimesInMs[i];
				}

				AverageTime = AverageTime/NUM_FRAMES_TO_TIME;

				Arnold_PercentRelativeSpeed = (FRAME_TIME_IN_MS*100)/AverageTime;
			}
		}
	}
#endif

}
#endif

#ifdef SHOW_TIME
unsigned long CPCEmulation_GetPercentRelativeSpeed(void)
{
	return Arnold_PercentRelativeSpeed;
}
#endif


/* set frame skip for emulation */
void CPC_SetFrameSkip(int FrameSkipCount)
{
	if (FrameSkipCount<FRAME_SKIP_MIN)
		FrameSkipCount = FRAME_SKIP_MIN;

	if (FrameSkipCount>FRAME_SKIP_MAX)
		FrameSkipCount = FRAME_SKIP_MAX;

	FrameSkip = FrameSkipCount;

	CurrentFrameIndex = 0;
}

int CPC_GetFrameSkip(void)
{
	return FrameSkip;
}

BOOL	CPC_IsAudioActive(void)
{
	return AudioActiveFlag;
}

void	CPC_SetAudioActive(BOOL State)
{
	if ((AudioActiveFlag==false) && (State==TRUE))
	{
		/* setup for audio playback */

		/* is host system able to playback sound? */
		if (Host_AudioPlaybackPossible())
		{
			/* yes it is */
			SOUND_PLAYBACK_FORMAT *pSoundPlaybackFormat;

			/* get playback format */
			pSoundPlaybackFormat = Host_GetSoundPlaybackFormat();

			if (pSoundPlaybackFormat!=NULL)
			{
				/* audio was previously disabled, but we want it to be enabled */
				//AudioEvent_SetFormat(pSoundPlaybackFormat->Frequency, pSoundPlaybackFormat->BitsPerSample, pSoundPlaybackFormat->NumberOfChannels);
				Audio_Init(pSoundPlaybackFormat->Frequency, pSoundPlaybackFormat->BitsPerSample, pSoundPlaybackFormat->NumberOfChannels,TRUE,FALSE);
	
				/* playing audio */
				AudioActiveFlag = TRUE;
			}
		}
		else
		{
			AudioActiveFlag = FALSE;
		}

	}

	if ((AudioActiveFlag==TRUE) && (State==FALSE))
	{
		/* audio was previously enabled, but we want it to be disabled */

		/* stop audio playback */
	}
}

/* this is called after every Z80 opcode executed */
/*void Z80_OpcodeFunc(int NopCount)
{
}
*/


void	CPC_ResetTiming(void)
{
	NopCountToDate = NOPS_PER_MONITOR_SCREEN;
	NopCountAcc = 0;
}


extern unsigned char *pAudioBuffer;
extern unsigned int AudioBufferSize;
#if 0
void	CPC_UpdateAudio(void)
{
	int CPCNopCount = CPC_GetNopCount();
	int NopsReached = CPCNopCount;

	if (AudioActiveFlag)
	{
		/* update sound buffer with events in audio events buffer */
		AudioEvent_TraverseAudioEventsAndBuildSampleData();
	
		/* convert PSG vol/Digiblaster data to sample data */
		AudioEvent_ConvertToOutputFormat();
	}

	/* restart buffer ready to fill with new data */
	AudioEvent_RestartEventBuffer();
}
#endif


extern unsigned char *pAudioBuffer;
extern unsigned int AudioBufferSize;
#if 0
void	CPC_UpdateAudio(void)
{
	if (AudioActiveFlag)
	{
		Digiblaster_EndFrame();
	}

	{
		int CPCNopCount = CPC_GetNopCount();
		int NopsReached = CPCNopCount;

		if (AudioActiveFlag)
		{
			/* update sound buffer with events in audio events buffer */
			NopsReached = AudioEvent_TraverseAudioEventsAndBuildSampleData(CPCNopCount,19968);
		}

		/* restart buffer ready to fill with new data */
		AudioEvent_RestartEventBuffer(NopsReached);
	}
}
#endif

extern BOOL DoNotScanKeyboard;

#if 0
void CPCEmulation_Run2(void)
{
	BOOL doBreak = FALSE;
	
	//wait for crtc ready
	int NP;
	while(!CRTCReady())
	{
		NP = Z80_ExecuteInstruction();
		CPC_UpdateNopCount(NP);
	}

	while (!doBreak)
	{
		int NopCount;
		int LocalNopCountToDate;

		//to make all windows events possibles
		doBreak = Host_ProcessSystemEvents();


		/* execute the instruction */
		#ifdef CPC_NODEBUGGER
				NopCount = Z80_ExecuteInstruction();
		#else
				NopCount = Debugger_Execute(); 
		#endif


		if (BoostZ80 > 0)
		{
			/* Accumulate the Nop counts */
			NopCountAcc += NopCount;
			/* See if we accumulated enough */
			NopCount = 0;
			while (NopCountAcc>=BoostZ80)
			{
				NopCount++;
				NopCountAcc-=BoostZ80;
			}
		}

		CPC_ExecuteCycles(NopCount);

		//Render display if VSYNK ok and 1 Frame completed
		//if ((!updated) && /*(Framecount > 0) &&*/ (LocalNopCountToDate <= NOPS_PER_MONITOR_SCREEN/2-100))
		if ((VSYNC_Display == TRUE) && (!updated))
		{
			VSYNC_Display = FALSE;
			// is rendering possible?
			if (Render_IsRendererActive())
			{
				// allow it to render
				CRTC_SetRenderState(FALSE);
				//dump whole display to screen
				Render_DumpDisplay();

				updated = TRUE;
			}
		}

		//How many NOPs since the last passage ?
		LocalNopCountToDate = NopCountToDate - NopCount;

		// nop counter is used to define when 1 frame completed
		if (LocalNopCountToDate <= 0)
		{
			int NopsToFrameEnd;
			NopsToFrameEnd = NopCount + LocalNopCountToDate;

			//update CRTC for NopCount cycles
			if (NopsToFrameEnd!=0) CRTC_DoCycles(NopsToFrameEnd);
			LocalNopCountToDate = 0;

			OneFrameAction();

			/* a whole screen has been timed */
			LocalNopCountToDate += NOPS_PER_MONITOR_SCREEN;
	
		}
		else // this doesn't work :(
		{
			/* update CRTC for NopCount cycles */
			CRTC_DoCycles(NopCount);
		}

		NopCountToDate = LocalNopCountToDate;

	}
	
}
#endif





BOOL CRTCReady(void);
void WaitForCRTCSynchronisation(void)
{
	//wait for crtc ready
	int NP;
	while(!CRTCReady())
	{
		NP = CPU_ExecuteCycles();
		CPC_UpdateNopCount(NP);
	}
}


long bug = 0;
extern BOOL Hack_Synchrosound;

void CPCEmulation_Run(void)
{
	BOOL doBreak = FALSE;

	Cycles = 0;

	while (!doBreak)
	{

		//int NopCount;
		//int LocalNopCountToDate;

		// if autorunfile is active, update it.
		if (AutoRunFile_Active()) AutoRunFile_Update();


		//to make all windows events possibles
		doBreak = Host_ProcessSystemEvents();


		//3528
		while ( ((Cycles <19968) && (!Hack_Synchrosound)) || ((GetLenghtBuff() < 3528) && (Hack_Synchrosound)) )
	    //while (Cycles <19968)
		{
			int NopCount;

			/* execute the instruction */
			NopCount = CPU_ExecuteCycles();

			if (NopCount==0) break;

			if (BoostZ80 > 0)
			{
				/* Accumulate the Nop counts */
				NopCountAcc += NopCount;
				/* See if we accumulated enough */
				NopCount = 0;
				while (NopCountAcc>=BoostZ80)
				{
					NopCount++;
					NopCountAcc-=BoostZ80;
				}
			}

			CPC_ExecuteCycles(NopCount);

			Audio_Update(NopCount);

			if (MonitorNeedupdate())
			{
				if (Render_IsRendererActive())
				{
					// allow it to render
					//CRTC_SetRenderState(FALSE);
					//dump whole display to screen

					DrawDisplay();
					CountFps();

				}
			}

			Cycles+=NopCount;

		}


		if (Cycles>=19968)
		{

			Cycles -= 19968;

			bug = bug + 1;

			/* auto type active? */
			if (AutoType_Active())
			{
				if (bug > 150)
				{
					/* update it */
					AutoType_Update();
				}
			}
			else
			{
				CPC_ClearKeyboard();

				/* scan keyboard/joysticks */
				DoKeyboard();
			}

			// ensure joysticks are updated
			Joystick_Update();

			// copy real keys to resolved keys
			CPC_PreResolveKeys();

			// then resolve key joy over that
			//KeyJoy_Resolve();

			// always do last after keyboard and joystick updates
			CPC_GenerateKeyboardClash();

			Audio_Commit();

			Host_Throttle();

			//Slowdown
			if (Slowdown) Sleep(100);

			CPC_ExecuteUpdateFunctions();


		}

	}
	
}


void CPC_ExecuteCycles(int NopCount)
{
		/* update CPC nop count - used for other hardware */
		CPC_UpdateNopCount(NopCount);
        FDC_Cycle();
		Computer_DoVideoCycles(NopCount);

		//NopCountToDate+=NopCount;

}


void OneFrameAction (void)
{
		
	/* Frame Skip Control code */
	CurrentFrameIndex++;
	if (CurrentFrameIndex > FrameSkip)
	{
		CurrentFrameIndex = 0;
		//VSYNC_Display = FALSE;//Now need to wait the vsync
	}

	// call speed throttle function - use this to throttle speed at 100% and update audio and input.
	Host_Throttle();

	//Slowdown
	if (Slowdown) Sleep(100);

	#ifdef SHOW_TIME
			/* works out the speed of the emulation based on the previous 10 
			frames. This method stores a frame time in ms for each frame in
			a table, when 10 frame times have been recorded, it works out
			the average of those times and updates the percentage speed. */
			{
				unsigned long CurrentTimeInMs;
				unsigned long MsPassed;
				int first = Arnold_PreviousTimeInMs;

				/* get time for this frame in ms */
				CurrentTimeInMs = Host_GetCurrentTimeInMilliseconds();

				/* work out ms passed based on previous ms value */
				MsPassed = CurrentTimeInMs - Arnold_PreviousTimeInMs;
				
				/* store this time */
				Arnold_PreviousTimeInMs = CurrentTimeInMs;
				
				if (!first)
				{
					/* store this frame time */
					FrameTimesInMs[FrameIndexForFrameTimes] = MsPassed;
					FrameIndexForFrameTimes++;

					if (FrameIndexForFrameTimes == NUM_FRAMES_TO_TIME)
					{
						int i;
						unsigned long AverageTime = 0;

						/* recalc relative speed */
						FrameIndexForFrameTimes = 0;

						for (i=0; i<NUM_FRAMES_TO_TIME; i++)
						{
							/* add on time for this frame */
							AverageTime+=FrameTimesInMs[i];
						}

						AverageTime = AverageTime/NUM_FRAMES_TO_TIME;

						Arnold_PercentRelativeSpeed = (FRAME_TIME_IN_MS*100)/AverageTime;
					}
				}
			}
	#endif
		

}



BOOL	CPCEmulation_CheckEndianness(void)
{
	BOOL EndianCorrect;
	unsigned long TestLong = 0;
	unsigned char *pLongPtr = (unsigned char *)&TestLong;

	pLongPtr[0] = 1;

#ifdef CPC_LSB_FIRST
	EndianCorrect = FALSE;
	if (TestLong == 1)
	{	
		/* on little endian, long = 1 */
		EndianCorrect = TRUE;
	}
#else
	EndianCorrect = TRUE;
	if (TestLong == 1)
	{
		/* on little endian, long = 1 */
		EndianCorrect = FALSE;
	}
#endif
	return EndianCorrect;
}
